<?php

use App\Http\Controllers\AboutUsController;
use App\Http\Controllers\Auth\LoginRegisterController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\CartController;
use App\Http\Controllers\CheckoutController;
use App\Http\Controllers\ContactUsController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\ShopController;
use App\Http\Controllers\WishlistController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

// Public routes (accessible to all users)
Route::get('/', [HomeController::class, 'index'])->name('home');
Route::get('about-us', [AboutUsController::class, 'index'])->name('about-us');
Route::get('shop', [ShopController::class, 'index'])->name('shop.index');
Route::get('detail', [ShopController::class, 'detail'])->name('shop.detail');
Route::get('blog', [BlogController::class, 'index'])->name('blog.index');
Route::get('contact-us', [ContactUsController::class, 'index'])->name('contact-us');
Route::get('wishlist', [WishlistController::class, 'index'])->name('wishlist');

Route::middleware(['guest'])->group(function () {
    // Routes for non-authenticated users
    Route::get('/register-login', [LoginRegisterController::class, 'loginRegisterForm'])->name('loginRegisterForm');
    Route::post('/register', [LoginRegisterController::class, 'register'])->name('register');
    Route::post('/login', [LoginRegisterController::class, 'login'])->name('login');
});
Route::get('/verifyEmail', [LoginRegisterController::class, 'verifyEmail'])->name('verifyEmail');

Route::post('/cart', [CartController::class, 'store'])->name('cart.store');
Route::get('/cart', [CartController::class, 'index'])->name('cart.index');
Route::get('/cart/truncate', [CartController::class, 'destroy'])->name('cart.destroy');
Route::post('/cart/remove', [CartController::class, 'remove'])->name('cart.remove');

Route::post('/cart/update', [CartController::class, 'update'])->name('cart.update');

Route::get('/changeDeliveryType', [CartController::class, 'changeDeliveryType'])->name('changeDeliveryType');

// Logout route (accessible only to authenticated users)
Route::middleware(['auth'])->group(function () {
    Route::get('/order', [OrderController::class, 'index'])->name('order.index');
    Route::get('/checkout', [CheckoutController::class, 'index'])->name('checkout.index');
    Route::post('/checkout', [CheckoutController::class, 'store'])->name('checkout.store');

    // Route::get('/logout', [LoginRegisterController::class, 'logout'])->name('logout');
    Route::get('/logout', [LoginRegisterController::class, 'logout'])->name('logout');
});