<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Dish;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cookie;

class ShopController extends Controller
{
    public function index(Request $request)
    {
        $user = Auth::check() ? Auth::user() : null;
        $already_in_cookie = Cookie::get('delivery_type');

        $delivery_type = 1;

        if ($user != null) {
            $delivery_type = $user->delivery_type;
            if ($delivery_type == null) {
                $user->delivery_type = 1;
                $user->save();
            }
        } else if ($user == null && $already_in_cookie != null) {
            $delivery_type = Cookie::get('delivery_type');
        } else {
            Cookie::queue('delivery_type', $delivery_type, 60 * 24 * 30);
        }

        $category_id = $request->category_id;

        $categories_dishes = Category::with('dishes')->when($category_id != null, function ($query) use ($category_id) {
            return $query->where('Cat_ID', $category_id);
        })->get();

        $categories = Category::with('dishes')->get();

        return view('shop.index', compact('categories', 'categories_dishes', 'delivery_type'));
    }

    public function detail(Request $request)
    {
        $user = Auth::check() ? Auth::user() : null;
        $already_in_cookie = Cookie::get('delivery_type');

        $delivery_type = 1;

        if ($user != null) {
            $delivery_type = $user->delivery_type;
            if ($delivery_type == null) {
                $user->delivery_type = 1;
                $user->save();
            }
        } else if ($user == null && $already_in_cookie != null) {
            $delivery_type = Cookie::get('delivery_type');
        } else {
            Cookie::queue('delivery_type', $delivery_type, 60 * 24 * 30);
        }

        $dish = Dish::where('DishID', $request->dish_id)->with('modifiers')->first();
        $related_dishes = Dish::where('Category', $dish->Category)->inRandomOrder()->take(4)->get();
        return view('shop.detail', compact('dish', 'related_dishes', 'delivery_type'));
    }
}