@extends('layout.master')

@section('content')
    <div class="slider-area-2">
        <div class="slider-active owl-dot-style owl-carousel">
            <div class="single-slider pt-210 pb-220 bg-img" style="background-image: url('{{ asset('banner-top.jpg') }}');">
                <div class="container">
                    <div class="slider-content slider-animated-2 text-center">
                        <h1 class="animated">Drink & Healthy Food</h1>
                        <h3 class="animated">Fresh, Healthy, and Organic.</h3>
                        <div class="slider-btn mt-90">
                            <a class="animated">Order Now</a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="single-slider pt-210 pb-220 bg-img" style="background-image:url(assets/img/slider/slider-3.jpg);">
                <div class="container">
                    <div class="slider-content slider-animated-2 text-center">
                        <h1 class="animated">Drink & Heathy Food</h1>
                        <h3 class="animated">Fresh Heathy and Organic.</h3>
                        <div class="slider-btn mt-90">
                            <a class="animated">Order Now</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="product-area pt-95 pb-70">
        <div class="custom-container">
            <div class="product-tab-list-wrap text-center mb-40 yellow-color">
                <div class="product-tab-list nav">
                    <a class="active" href="#tab1" data-bs-toggle="tab" data-category="All">
                        <h4>All</h4>
                    </a>
                    @forelse($categories->take(8) as $category)
                        <a href="#tab3" data-bs-toggle="tab" data-category="{{ $category->CategoryName }}">
                            <h4>{{ $category->CategoryName }}</h4>
                        </a>
                    @empty
                    @endforelse

                </div>
                <p>Discover a world of flavors in our carefully curated categories. Click to explore delectable dishes that
                    cater to every palate. From appetizers to main courses, our menu is a culinary journey you won't want to
                    miss.</p>
            </div>
            <div class="tab-content jump yellow-color">
                <div class="row">
                    @forelse($dishes as $dish)
                        <div class="custom-col-5" data-category="{{ $dish->Category }}">
                            <div class="product-wrapper mb-25">
                                <div class="product-img">
                                    @php
                                        $image = str_replace('\Menu Items Image\\', '', $dish->Photo);
                                    @endphp
                                    @php
                                        $queryParams = ['dish_id' => $dish->DishID];
                                        $url = route('shop.detail') . '?' . http_build_query($queryParams);
                                    @endphp
                                    <a href="{{ $url }}">
                                        <img src="{{ asset('Menu-Items-Image/' . $image) }}" alt="">
                                    </a>

                                    <div class="product-action">
                                        <div class="pro-action-left">
                                            <a title="Add To Cart" href="#" class="add-to-cart"
                                                data-dish-id="{{ $dish->DishID }}" data-dish-name="{{ $dish->DishName }}"
                                                data-dish-price="{{ $dish->DIRate }}">
                                                <i class="ion-android-cart"></i> Add To Cart
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="product-content">
                                    <h4>
                                        @php
                                            $queryParams = ['dish_id' => $dish->DishID];
                                            $url = route('shop.detail') . '?' . http_build_query($queryParams);
                                        @endphp
                                        <a href="{{ $url }}">{{ $dish->DishName }} </a>
                                    </h4>
                                    <div class="product-price-wrapper">
                                        <span>£ {{ $dish->DIRate }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                    @empty
                    @endforelse
                </div>
            </div>
        </div>
    </div>
    <div class="banner-area row-col-decrease pb-75 clearfix">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                    <div class="single-banner mb-30">
                        <div class="hover-style">
                            <a href="#"><img src="assets/img/banner/banner-7.jpg" alt=""></a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                    <div class="single-banner mb-30">
                        <div class="hover-style">
                            <a href="#"><img src="assets/img/banner/banner-8.jpg" alt=""></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="banner-area">
        <div class="container">
            <div class="discount-overlay bg-img pt-130 pb-130"
                style="background-image:url(assets/img/banner/banner-4.jpg);">
                <div class="discount-content text-center">
                    <h3>It's Time To Start <br>Your Own Revolution By Laurent</h3>
                    <p>Exclusive Offer -10% Off This Week</p>
                    <div class="banner-btn">
                        <a href="#">Order Now</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="brand-logo-area pt-100 pb-100">
        <div class="container">
            <div class="brand-logo-active owl-carousel">
                <div class="single-brand-logo">
                    <img alt="" src="assets/img/brand-logo/logo-1.png">
                </div>
                <div class="single-brand-logo">
                    <img alt="" src="assets/img/brand-logo/logo-2.png">
                </div>
                <div class="single-brand-logo">
                    <img alt="" src="assets/img/brand-logo/logo-3.png">
                </div>
                <div class="single-brand-logo">
                    <img alt="" src="assets/img/brand-logo/logo-4.png">
                </div>
                <div class="single-brand-logo">
                    <img alt="" src="assets/img/brand-logo/logo-5.png">
                </div>
                <div class="single-brand-logo">
                    <img alt="" src="assets/img/brand-logo/logo-2.png">
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const categoryLinks = document.querySelectorAll(".product-tab-list a[data-bs-toggle='tab']");
            const dishes = document.querySelectorAll(".custom-col-5");

            // Function to show only dishes in the selected category
            function showDishesInCategory(categoryName) {
                dishes.forEach((dish) => {
                    const dishCategory = dish.getAttribute("data-category");
                    if (dishCategory === categoryName || categoryName === "All") {
                        dish.style.display = "block";
                    } else {
                        dish.style.display = "none";
                    }
                });
            }

            // Initially show all dishes (All category)
            showDishesInCategory("All");

            // Add click event listeners to category links
            categoryLinks.forEach((link) => {
                link.addEventListener("click", (event) => {
                    event.preventDefault();
                    const categoryName = event.currentTarget.textContent.trim();
                    showDishesInCategory(categoryName);
                });
            });
        });


        $(document).ready(function() {

            $('#exampleModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget); // Button that triggered the modal
                var data = button.data(
                    'dish'); // Get the dish data and image path from the button's data attribute

                // Update modal content with dish data
                $('#dishName').text(data.dish.DishName);
                $('#dishPrice').text('$' + data.dish.DIRate);

                // Update modal image source
                $('#dishImage').attr('src', data.image);
            });

            $(".add-to-cart").click(function(event) {
                event.preventDefault();

                var dishId = $(this).data("dish-id");
                var dishName = $(this).data("dish-name");
                var dishPrice = $(this).data("dish-price");
                var quantity = 1; // You can adjust this as needed

                $.ajax({
                    url: "{{ route('cart.store') }}",
                    type: "POST",
                    data: {
                        _token: "{{ csrf_token() }}",
                        dish_id: dishId,
                        dish_name: dishName,
                        quantity: quantity,
                        price: dishPrice,
                    },
                    success: function(response) {
                        // Check if the response contains a success message
                        if (response.message) {
                            window.location.reload();
                        } else {
                            // Handle other cases as needed
                        }
                    },
                    error: function(xhr, status, error) {
                        // Handle error, e.g., display an error message
                        console.error(error);
                    },
                });
            });
        });
    </script>
@endsection
