@extends('layout.master')

@section('content')
    <!-- shopping-cart-area start -->
    <div class="cart-main-area pt-95 pb-100">
        <div class="container">
            <h3 class="page-title">Your cart items</h3>
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                    <form action="#">
                        <div class="table-content table-responsive">
                            <table>
                                <thead>
                                    <tr>
                                        <th>Image</th>
                                        <th>Product Name</th>
                                        <th>Until Price</th>
                                        <th>Qty</th>
                                        <th>Subtotal</th>
                                        <th>action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $sum = 0;
                                    @endphp
                                    @forelse($cart_data as $cart)
                                        <tr data-item-id="{{ $cart->id }}">
                                            <td class="product-thumbnail">
                                                @php($image = str_replace('\Menu Items Image\\', '', $cart->dish->Photo ?? ''))
                                                <a href="#"><img src="{{ asset('Menu-Items-Image/' . $image) }}"
                                                        alt="" width="86px"></a>
                                            </td>
                                            <td class="product-name"><a href="#">{{ $cart->dish->DishName ?? '' }}</a></td>
                                            <td class="product-price-cart"><span class="amount">£ {{ $cart->price ?? '' }}</span>
                                            </td>
                                            <td class="product-quantity">
                                                <div class="cart-plus-minus">
                                                    <input class="cart-plus-minus-box" type="text" name="qtybutton"
                                                        value="{{ $cart->quantity ?? '' }}">
                                                </div>
                                            </td>
                                            <td class="product-subtotal">£ {{ $cart->price * $cart->quantity ?? '' }}</td>
                                            <td class="product-remove">
                                                <a href="#" onclick="removeItem({{ $cart->id }})"><i
                                                        class="fa fa-times"></i></a>
                                            </td>

                                        </tr>
                                        <?php $sum = $sum + $cart->price * $cart->quantity; ?>
                                    @empty
                                        <tr colspan="6">
                                            <td>
                                                Your cart is empty
                                            </td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="cart-shiping-update-wrapper">
                                    <div class="cart-shiping-update">
                                        <a href="{{ route('shop.index') }}">Continue Shopping</a>
                                    </div>
                                    <div class="cart-clear">
                                        <a href="{{ route('cart.destroy') }}">Clear Shopping Cart</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                    <div class="row">
                        <div class="col-lg-12 col-md-12">
                            <div class="grand-totall">
                                <div class="title-wrap">
                                    <h4 class="cart-bottom-title section-bg-gary-cart">Cart Total</h4>
                                </div>
                                <h4 class="grand-totall-title">Grand Total <span>£ {{ $sum }}</span>
                                </h4>
                                <a href="{{ route('checkout.index') }}">Proceed to Checkout</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function() {
            // Function to update the quantity of a cart item
            function updateCartItem(id, quantity) {
                $.ajax({
                    type: 'POST',
                    url: '{{ route('cart.update') }}', // Replace with the actual route name
                    data: {
                        _token: '{{ csrf_token() }}',
                        id: id,
                        quantity: quantity
                    },
                    success: function(response) {
                        window.location.reload();
                    },
                    error: function(response) {
                        console.log('Error:', response);
                    }
                });
            }

            // Increment button click event
            $(document).on('click', '.inc', function() {
                var row = $(this).closest('tr');
                var id = row.data('item-id'); // Retrieve 'id' from 'data-item-id'
                var quantityInput = row.find('.cart-plus-minus-box');
                var currentQuantity = parseInt(quantityInput.val());
                var newQuantity = currentQuantity;
                quantityInput.val(newQuantity);

                // Update the cart item with the new quantity
                updateCartItem(id, newQuantity);
            });

            // Decrement button click event
            $(document).on('click', '.dec', function() {
                var row = $(this).closest('tr');
                var id = row.data('item-id'); // Retrieve 'id' from 'data-item-id'
                var quantityInput = row.find('.cart-plus-minus-box');
                var currentQuantity = parseInt(quantityInput.val());

                if (currentQuantity + 1 > 1) {
                    var newQuantity = currentQuantity;
                    quantityInput.val(newQuantity);

                    // Update the cart item with the new quantity
                    updateCartItem(id, newQuantity);
                }
            });
        });

        function removeItem(id) {
            $.ajax({
                type: 'POST',
                url: '{{ route('cart.remove') }}', // Replace with the actual route name
                data: {
                    _token: '{{ csrf_token() }}',
                    id: id,
                },
                success: function(response) {
                    window.location.reload();
                },
                error: function(response) {
                    console.log('Error:', response);
                }
            });
        }
    </script>
@endsection
