<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Dish;
use Illuminate\Http\Request;

class ShopController extends Controller
{
    public function index(Request $request)
    {
        $category_id = $request->category_id;

        $categories_dishes = Category::with('dishes')->when($category_id != null, function ($query) use ($category_id) {
            return $query->where('Cat_ID', $category_id);
        })->get();

        $categories = Category::with('dishes')->get();

        return view('shop.index', compact('categories', 'categories_dishes'));
    }

    public function detail(Request $request)
    {
        $dish = Dish::where('DishID', $request->dish_id)->first();
        $related_dishes = Dish::where('Category', $dish->Category)->inRandomOrder()->take(4)->get();
        return view('shop.detail', compact('dish', 'related_dishes'));
    }
}