<?php

namespace App\Http\Controllers;

use App\Models\Order;
use Illuminate\Http\Request;
use App\Models\RestaurantPOS_OrderedProductBillHD;
use Illuminate\Support\Facades\Auth;

class OrderController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $user_id = Auth::check() ? Auth::user()->id : $request->id;
        $session_id = $request->session_id;

        $order_ids = Order::when($user_id != null, function ($query) use ($user_id) {
            return $query->where('user_id', $user_id);
        })
            ->when($session_id != null, function ($query) use ($session_id) {
                return $query->where('session_id', $session_id);
            })->pluck('Id');

        $orders = RestaurantPOS_OrderedProductBillHD::with('dish_name', 'dish')->whereIn('BillId', $order_ids)->get();

        if ($request->wantsJson()) {
            return response()->json(['status' => 200, 'data' => $orders]);
        } else {
            return view('order.index', compact('orders'));
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(Order $order)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Order $order)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Order $order)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Order $order)
    {
        //
    }
}