@extends('layout.master')

@section('content')
    <div class="shop-page-area pt-100 pb-100">
        <div class="container">
            <div class="row flex-row-reverse">
                <div class="col-lg-9">
                    <div class="banner-area pb-30">
                        <a href="{{ route('shop.detail') }}"><img alt="" src="assets/img/banner/banner-49.jpg"></a>
                    </div>
                    <div class="shop-topbar-wrapper">
                        <div class="shop-topbar-left">
                            <ul class="view-mode">
                                <li class="active"><a href="#product-grid" data-view="product-grid"><i
                                            class="fa fa-th"></i></a></li>
                                <li><a href="#product-list" data-view="product-list"><i class="fa fa-list-ul"></i></a></li>
                            </ul>
                        </div>
                        <div class="product-sorting-wrapper">
                            <div class="product-shorting shorting-style">
                                <label>View:</label>
                                <select>
                                    <option value=""> 20</option>
                                    <option value=""> 23</option>
                                    <option value=""> 30</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="grid-list-product-wrapper">
                        <div class="product-grid product-view pb-20">
                            <div class="row">
                                @forelse($categories_dishes as $key1 => $category)
                                    @forelse($category->dishes as $key2 => $dish)
                                        <div class="product-width col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12 mb-30">
                                            <div class="product-wrapper">
                                                <div class="product-img">
                                                    @php
                                                        $queryParams = ['dish_id' => $dish->DishID];
                                                        $url = route('shop.detail') . '?' . http_build_query($queryParams);
                                                    @endphp
                                                    <a href="{{ $url }}">
                                                        @php
                                                            $image = str_replace('\Menu Items Image\\', '', $dish->Photo);
                                                        @endphp
                                                        <img src="{{ asset('Menu-Items-Image/' . $image) }}" alt="">
                                                    </a>
                                                    <div class="product-action">
                                                        <div class="pro-action-left">
                                                            <a title="Add To Cart" href="#" class="add-to-cart"
                                                                data-dish-id="{{ $dish->DishID }}"
                                                                data-dish-name="{{ $dish->DishName }}"
                                                                data-dish-price="{{ $dish->DIRate }}">
                                                                <i class="ion-android-cart"></i> Add To Cart
                                                            </a>
                                                        </div>
                                                        <div class="pro-action-right">
                                                            <a href="#" data-bs-toggle="modal"
                                                                data-bs-target="#exampleModal"
                                                                data-dish="{{ json_encode(['dish' => $dish, 'image' => asset('Menu-Items-Image/' . $image)]) }}">
                                                                <i class="ion-android-open"></i>
                                                            </a>

                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="product-content">
                                                    <h4>
                                                        @php
                                                            $queryParams = ['dish_id' => $dish->DishID];
                                                            $url = route('shop.detail') . '?' . http_build_query($queryParams);
                                                        @endphp
                                                        <a href="{{ $url }}">{{ $dish->DishName }}</a>
                                                    </h4>
                                                    <div class="product-price-wrapper">
                                                        <span>£ {{ $dish->DIRate }}</span>
                                                    </div>
                                                </div>
                                                <div class="product-list-details">
                                                    <h4>
                                                        @php
                                                            $queryParams = ['dish_id' => $dish->DishID];
                                                            $url = route('shop.detail') . '?' . http_build_query($queryParams);
                                                        @endphp
                                                        <a href="{{ $url }}">{{ $dish->DishName }}</a>
                                                    </h4>
                                                    <div class="product-price-wrapper">
                                                        <span>£ {{ $dish->DIRate }}</span>
                                                    </div>
                                                    <div class="shop-list-cart-wishlist">
                                                        <a href="#" title="Add To Cart"><i
                                                                class="ion-android-cart"></i></a>
                                                        <a href="#" data-bs-toggle="modal"
                                                            data-bs-target="#exampleModal"
                                                            data-dish="{{ json_encode(['dish' => $dish, 'image' => asset('Menu-Items-Image/' . $image)]) }}">
                                                            <i class="ion-android-open"></i>
                                                        </a>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @empty
                                    @endforelse
                                @empty
                                    No Items
                                @endforelse
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="shop-sidebar-wrapper gray-bg-7 shop-sidebar-mrg">
                        <div class="shop-widget">
                            <h4 class="shop-sidebar-title">Shop By Categories</h4>
                            <div class="shop-catigory">
                                <ul id="faq">
                                    @forelse($categories as $category)
                                        @php
                                            $queryParams = ['category_id' => $category->Cat_ID];
                                            $url = route('shop.index') . '?' . http_build_query($queryParams);
                                        @endphp
                                        <li><a href="{{ $url }}">{{ $category->CategoryName }}</a>
                                        </li>
                                    @empty
                                    @endforelse
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function() {
            // Listen for the modal show event
            $('#exampleModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget); // Button that triggered the modal
                var data = button.data(
                    'dish'); // Get the dish data and image path from the button's data attribute

                // Update modal content with dish data
                $('#dishName').text(data.dish.DishName);
                $('#dishPrice').text('$' + data.dish.DIRate);

                // Update modal image source
                $('#dishImage').attr('src', data.image);
            });

            $(".add-to-cart").click(function(event) {
                event.preventDefault();

                var dishId = $(this).data("dish-id");
                var dishName = $(this).data("dish-name");
                var dishPrice = $(this).data("dish-price");
                var quantity = 1; // You can adjust this as needed

                $.ajax({
                    url: "{{ route('cart.store') }}",
                    type: "POST",
                    data: {
                        _token: "{{ csrf_token() }}",
                        dish_id: dishId,
                        dish_name: dishName,
                        quantity: quantity,
                        price: dishPrice,
                    },
                    success: function(response) {
                        // Check if the response contains a success message
                        if (response.message) {
                            window.location.reload();
                        } else {
                            // Handle other cases as needed
                        }
                    },
                    error: function(xhr, status, error) {
                        // Handle error, e.g., display an error message
                        console.error(error);
                    },
                });
            });
        });
    </script>
@endsection
